<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Produto</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.261.6.2">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.261.6.2">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>

  <link rel="stylesheet" href="dist/css/custom.css?versao=3.261.6.2">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.261.6.2">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.261.6.2">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.261.6.2" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.261.6.2">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.261.6.2" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.261.6.2">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.261.6.2">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.261.6.2">
  <link rel="stylesheet" href="https://cdn.datatables.net/select/1.6.0/css/select.dataTables.min.css">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.261.6.2">
  <link rel="stylesheet" type="text/css" href="dist/css/sisplan.newColorsButtons.css?versao=3.261.6.2" />
  <link rel="stylesheet" type="text/css" href="dist/css/sisplan.adjustDataTableButtons.css?versao=3.261.6.2" />
  <style>
    #tabelaCadProduto td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaCadProduto td {
      padding: 0 !important;
      padding-left: 10px !important;
    }

    .btnBarra {
      color: black;
      border: 0 none;
      border-radius: 0px;
      cursor: pointer;
      padding: 10px 5px;
      margin: 10px 5px 10px 5px;
      float: right;
    }

    .dropProduto::-webkit-scrollbar {
      width: 12px;
    }

    .dropProduto::-webkit-scrollbar-track {
      background: var(--btn-hover);
    }

    .dropProduto::-webkit-scrollbar-thumb {
      background: var(--color-secondary);
      border-radius: 20px;
      border: 3px solid var(--font-card-color);
    }

    .dropProduto {
      height: 280px;
      overflow-x: auto;
      min-width: 12rem !important;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      border-radius: 3px !important;
      padding: 0 1.0em 0 1.0em !important;
      margin: 0 0 0 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
    }

    .input-group-append>a>i {
      margin-left: 0 !important;
      padding-left: 5px;
      padding-right: 5px;
    }

    .grupo_botao>button>i {
      margin-left: 0 !important;
      padding-left: 5px !important;
      padding-right: 5px !important;
    }

    .btn-opcao {
      padding-left: 0px !important;
      padding-right: 0px !important;
      text-align: center !important;
    }

    .bg-button {
      background-color: var(--buttonOpcoes) !important;
    }

    .bg-button:hover {
      filter: brightness(0.9);
      transition: 0.7s ease;
    }

    #tabelaProdutosUtilizacao tr td,
    #tabelaProdutosUtilizacao th {
      padding: 4px 12px;
    }

    .bordaTabelasUtilizacao {
      padding: 10px;
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
    }

    .dataTables_length {
      margin-top: 0px !important;
    }

    .dataTables_filter {
      margin-bottom: 3px !important;
    }

    #bordaImagem {
      width: 100%;
      height: 55vh;
      border: solid #fff;
      border-radius: 4px;
      border-width: 2px;
      padding: 20px;
      margin-top: 25px;
    }

    #infoimagem {
      max-width: 100%;
      max-height: 100%;
      width: auto;
      height: auto;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Produto</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">

            </div><!-- /.col -->
          </div><!-- /.row -->
        </div>
        <div class="container-fluid">
          <div class="row card" id="tabelaCadProdutoForne">
            <div class="col-12 d-flex justify-content-between" style="margin-top: 8px; padding-left: 20px; padding-right: 20px; margin-bottom: 5px">
              <div class="d-flex align-items-center" style="z-index:9999 !important">
                <button class="btn btn-sisp btnFiltros" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
                <button class="btn btn-sisp btn-danger ml-1" id="btnNovoProduto"><span class="fas fa-plus"></span> Incluir</button>
                <button id="btnImprimirAcessoProd" class="btn-sisp btn btn-primary ml-1"><i class="fas fa-print"></i> Imprimir</button>
                <button id="btnAlterarDadosEmMassa" data-target="modalAlterarDadosEmMassa" style="color: white" class="btn btn-sisp btnVerde ml-1" title="Clique para alterar dados em massa dos produtos selecionados."><i class="fas fa-sync"></i> Alterar Selecionados</button>
                <button id="btnUtilizacao" data-target="modalUtilizacao" class="btn-sisp btn btnFiltros ml-1"><i class="fas fa-clipboard-list"></i> Utilização</button>
              </div>
            </div>

            <div class="col-sm-12 table-responsive card-body pb-0" style="height: 65vh;" >
              <h5 class="mb-0">Lista de Produtos</h5>
              <table id="tabelaCadProduto" class="table table-sm table-select table-hover" width="100%" style="white-space: nowrap; width:100%">
                <thead>
                  <tr>
                    <th class="th-sm" style="max-width: 20px">
                      <div class="icheck-primary d-inline">
                        <input type="checkbox" id="cbSelAll">
                        <label for="cbSelAll"></label>
                      </div>
                    </th>
                    <th class="th-sm">Código Produto
                    </th>
                    <th class="th-sm">Código2
                    </th>
                    <th class="th-sm">Foto
                    </th>
                    <th class="th-sm">Descrição
                    </th>
                    <th class="th-sm">Data Cadastro
                    </th>
                    <th class="th-sm">Preço</th>
                    <th class="th-sm">Ativo</th>
                    <th class="th-sm">Faixa</th>
                    <th class="th-sm">Desc. Faixa</th>
                    <th class="th-sm">Grupo</th>
                    <th class="th-sm">Desc. Grupo</th>
                    <th class="th-sm">Marca</th>
                    <th class="th-sm">Desc. Marca</th>
                    <th class="th-sm">Coleção</th>
                    <th class="th-sm">Desc. Coleção</th>
                    <th class="th-sm">Unidade</th>
                    <th class="th-sm">Un. Venda</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <hr>
             <div class="row">
              <div class="col-sm-6 table-responsive card-body pb-0 pt-2 border-r-1" style="height: 65vh;">
                <h5 class="mb-0">Cores</h5>
                <table id="tabelaCores" class="table table-sm table-select table-hover" width="100%" style="white-space: nowrap; width:100%">
                  <thead>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
              <div class="col-sm-6 table-responsive card-body pb-0 pt-2" style="height: 65vh;">
                <h5 class="mb-0">Imagem do produto</h5>
                <div class="d-flex justify-content-center" id="bordaImagem">
                  <img class="pop img img-fluid imagem" id="infoimagem" alt="Imagem Produto" src="./dist/img/prod-1.png">
                </div>
              </div>
            </div>
          </div>
          <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-xl" role="document">
              <div class="modal-content" id="modalBody">
                <div class="modal-header">
                  <h4 class="modal-title">Filtros</h4>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <div class="row justify-content-sm-start justify-content-center mb-3">
                    <div class="col-auto">
                      <fieldset class="form border-Field mb-0 pb-0 d-sm-flex d-block">
                        <legend class="textoBorda mb-0 pb-0">Opções</legend>
                        <div class="m-1 icheck-primary">
                          <input type="radio" id="cbTodos" name="cbStatusProd" value="" checked>
                          <label for="cbTodos">Todos</label>
                        </div>
                        <div class="m-1 icheck-primary">
                          <input type="radio" id="cbAtivo" name="cbStatusProd" value="S">
                          <label for="cbAtivo">Ativo</label>
                        </div>
                        <div class="m-1 icheck-primary">
                          <input type="radio" id="cbInativo" name="cbStatusProd" value="N">
                          <label for="cbInativo">Inativo</label>
                        </div>
                      </fieldset>
                    </div>

                    <button class="btn btn-danger btn-sisp d-none" type='button' style="height: 40px;margin-top: 10px;" id="btnSelecionarEmpresas">Selecionar Empresas</button> 
                  </div>
                  <div class="row">
                    <div class="col-xl-2 col-lg-3 col-6 form-group">
                      <div>
                        <label for="txtCadastroDe">Data Cadastro De:</label>
                        <div class="relative">
                          <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtCadastroDe">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-2 col-lg-3 col-6 form-group">
                      <div>
                        <label for="txtCadastroAte">Até:</label>
                        <div class="relative">
                          <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control validate" id="txtCadastroAte">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-2 col-lg-3 col-6 form-group">
                      <div>
                        <label for="txtAlteracaoDe">Data Alteração De:</label>
                        <div class="relative">
                          <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtAlteracaoDe">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-2 col-lg-3 col-6 form-group">
                      <div>
                        <label for="txtAlteracaoAte">Até:</label>
                        <div class="relative">
                          <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control validate" id="txtAlteracaoAte">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtProduto">Produto: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtProduto" name="txtProduto" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnProduto" name="btnProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtColecao">Coleção: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtColecao" name="txtColecao" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnColecao" name="btnColecao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaColecao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtMarca">Marca: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtMarca" name="txtMarca" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnMarca" name="btnMarca" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaMarca" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtGrupo">Grupo: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtGrupo" name="txtGrupo" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnGrupo" name="btnGrupo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaGrupo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtLinha">Linha: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtLinha" name="txtLinha" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnLinha" name="btnLinha" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaLinha" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtStatus">Status: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtStatus" name="txtStatus" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnStatus" name="btnStatus" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaStatus" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtEtiqueta">Etiqueta: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtEtiqueta" name="txtEtiqueta" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnEtiqueta" name="btnEtiqueta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaEtiqueta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtCliente">Cliente: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtCliente" name="txtCliente" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtCategoria">Categoria: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtCategoria" name="txtCategoria" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnCategoria" name="btnCategoria" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaCategoria" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtTipoProduto">Tipo Produto: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtTipoProduto" name="txtTipoProduto" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnTipoProduto" name="btnTipoProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaTipoProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtModelo">Modelo: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtModelo" name="txtModelo" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnModelo" name="btnModelo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaModelo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtCodigoNcm">Código NCM: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtCodigoNcm" name="txtCodigoNcm" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnCodigoNcm" name="btnCodigoNcm" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaCodigoNcm" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtCstIcms">CST ICMS: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtCstIcms" name="txtCstIcms" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnCstIcms" name="btnCstIcms" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaCstIcms" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtCstIpiSaida">CST IPI Saída: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtCstIpiSaida" name="txtCstIpiSaida" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnCstIpiSaida" name="btnCstIpiSaida" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaCstIpiSaida" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtCstIpiEntrada">CST IPI Entrada: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtCstIpiEntrada" name="txtCstIpiEntrada" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnCstIpiEntrada" name="btnCstIpiEntrada" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaCstIpiEntrada" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtFaixa">Faixa: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtFaixa" name="txtFaixa" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnFaixa" name="btnFaixa" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaFaixa" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtCor">Cor: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtCor" name="txtCor" multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnCor" name="btnCor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaCor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" class="labelGeral" data-success="right" for="selectTipoVenda">Tipo Venda:</label>
                      <select class="input-default focus form-control" title='Quando a opção selecionada for "Não considerar", esse campo não será considerado na consulta.' data-dropdown-css-class="select2-danger" id="selectTipoVenda" aria-describedby="tipoError" class="custom-select focus">
                        <option value="">Não considerar</option>
                        <option value="0">Produção</option>
                        <option value="1">Revenda</option>
                      </select>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" class="labelGeral" data-success="right" for="selectPosse">Posse:</label>
                      <select class="input-default focus form-control" title='Quando a opção selecionada for "Não considerar", esse campo não será considerado na consulta.' data-dropdown-css-class="select2-danger" id="selectPosse" aria-describedby="tipoError" class="custom-select focus">
                        <option value="">Não considerar</option>
                        <option value="0">0 - Mercadoria de propriedade do informante e em seu poder</option>
                        <option value="1">1 - Mercadoria de propriedade do informante em poder de terceiros</option>
                        <option value="2">2 - Mercadoria de propriedade de terceiros em poder do informante</option>
                      </select>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" class="labelGeral" data-success="right" for="selectImportado">Importado:</label>
                      <select class="input-default focus form-control" title='Quando a opção selecionada for "Não considerar", esse campo não será considerado na consulta.' data-dropdown-css-class="select2-danger" id="selectImportado" aria-describedby="tipoError" class="custom-select focus">
                        <option value="">Não considerar</option>
                        <option value="N">Não</option>
                        <option value="D">Diretamente</option>
                        <option value="I">Indiretamente</option>
                      </select>
                    </div>
                  </div>
                </div>
                <div class="modal-footer justify-content-start pl-0">
                  <div class="row col-12">
                    <div class="col-md-4 col-4">
                      <label for="txtOrdem">Opção de Relatório:</label>
                      <div class="relative d-flex align-items-center">
                        <select id="txtOrdem" class="input-default focus custom-select">
                        </select>
                        <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                          <i class="fas fa-check"></i>
                        </button>
                      </div>
                    </div>
                    <div class="col-md-8 col-8 d-flex justify-content-end align-items-end pr-2">
                      <div class="d-flex">
                        <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222">
                          <span class="fas fa-trash"></span> Limpar Filtros
                        </button>
                        <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                          <span class="fas fa-search"></span> Consultar
                        </button>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modalBarra" tabindex="-1" role="dialog" aria-labelledby="modalContas" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Barra - Cadastro de Itens de Estoque</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pb-0">
          <div class="row">
            <div class="col-xl-4">
              <div class="group-default form-group">
                <label data-error="wrong" data-success="right" for="txtCodigoProduto">Codigo Produto</label>
                <div class="relative">
                  <input type="text" placeholder="Codigo Produto" class="input-default focus form-control validate" id="txtCodigoProduto" name="txtCodigoProduto" disabled>
                </div>
              </div>
            </div>
            <div class="col-xl-8">
              <div class="group-default form-group">
                <label data-error="wrong" data-success="right" for="txtDescricaoProduto">Descrição</label>
                <div class="relative">
                  <input type="text" placeholder="Descricao Produto" class="input-default focus form-control validate" id="txtDescricaoProduto" name="txtDescricaoProduto" disabled>
                </div>
              </div>
            </div>
          </div>
          <div>
            <div class="card">
              <div class="card-body px-0 pb-0 pt-0" style="min-height: 100px; max-height: 400px; overflow-y: auto;">
                <div class="col-sm-12 table-responsive card-body px-0 pb-0 pt-0">
                  <table id="tabelaBarra" style="white-space: nowrap" class="table table-sm table-select table-hover" width="100%">
                    <thead></thead>
                    <tbody></tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button class="btn btn-warning btnBarra btn-sisp" id="btnConfirmarBarra"> Confirmar</button>
            <button class="btn btn-primary btnBarra btn-sisp" id="btnGeraEan13"> Gera EAN13</button>
            <button class="btn btn-primary btnBarra btn-sisp" id="btnGeraBarra128"> Gera Barra 128</button>
            <button class="btn btn-primary btnBarra btn-sisp d-none" id="btnGeraDun14Barra"> Gera Dun14</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modalRelacionarProduto" tabindex="-1" role="dialog" aria-labelledby="modalContas" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Relacionar Produtos</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="divProdutosPai">
            <div class="row">
              <div class="col-sm-6 col-xl-2" id="tourcodigo">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigoProdutoPai">Código do Produto Pai </label>
                <input type="text" class="input-default focus form-control" value="26205" id="txtCodigoProdutoPai" aria-describedby="codError" disabled name="txtCodigoProdutoPai" placeholder="Código" aria-invalid="false" disabled="" readonly="">
              </div>
              <div class="col-sm-6 col-xl-4">
                <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtCorPaiRelacionamento">Cor Pai: </label>
                <div class="relative" style="margin-top: 5px;">
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control ui-autocomplete-input" id="txtCorPaiRelacionamento" name="txtCorPaiRelacionamento" placeholder="Cor" autocomplete="off">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-CorPaiRelacionamento" name="btn-CorPaiRelacionamento" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-CorPaiRelacionamento" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-sm-6 col-xl-4">
                <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtTamanhoPaiRelacionamento">Tamanho Pai: </label>
                <div class="relative" style="margin-top: 5px;">
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control ui-autocomplete-input" id="txtTamanhoPaiRelacionamento" name="txtTamanhoPaiRelacionamento" placeholder="Tamanho" autocomplete="off">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-TamanhoPaiRelacionamento" name="btn-TamanhoPaiRelacionamento" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-TamanhoPaiRelacionamento" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="d-flex align-items-end col-sm-6 col-xl-2">
                <button class="btn btn-danger btn-sisp" id="btnAdicionarProdutoPai" style="width: 100%;"> Adicionar</button>
              </div>
            </div>

            <div class="row">
              <div class="col-sm-12 table-responsive card-body px-0 pb-0 pt-0">
                <table id="tabelaProdutosPaisRelacionados" class="table table-sm table-select table-hover" width="100%">
                  <thead></thead>
                  <tbody></tbody>
                </table>
              </div>
            </div>
          </div>
          <div class="divProdutosFilhos d-none">
            <div class="row">
              <div class="col-sm-4 col-xl-3">
                <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtProdutoFilhoRelacionamento">Produto Filho: </label>
                <div class="relative" style="margin-top: 5px;">
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control ui-autocomplete-input" id="txtProdutoFilhoRelacionamento" name="txtProdutoFilhoRelacionamento" placeholder="Produto" autocomplete="off">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-ProdutoFilhoRelacionamento" name="btn-ProdutoFilhoRelacionamento" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-ProdutoFilhoRelacionamento" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-sm-4 col-xl-3">
                <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtCorFilhoRelacionamento">Cor Filho: </label>
                <div class="relative" style="margin-top: 5px;">
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control ui-autocomplete-input" id="txtCorFilhoRelacionamento" name="txtCorFilhoRelacionamento" placeholder="Cor" autocomplete="off">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-CorFilhoRelacionamento" name="btn-CorFilhoRelacionamento" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-CorFilhoRelacionamento" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-sm-4 col-xl-3">
                <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtTamanhoFilhoRelacionamento">Tamanho Filho: </label>
                <div class="relative" style="margin-top: 5px;">
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control ui-autocomplete-input" id="txtTamanhoFilhoRelacionamento" name="txtTamanhoFilhoRelacionamento" placeholder="Tamanho" autocomplete="off">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-TamanhoFilhoRelacionamento" name="btn-TamanhoFilhoRelacionamento" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-TamanhoFilhoRelacionamento" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-sm-6 col-xl-1" id="tourQuantidade">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtQuantidadeFilho">Qtde. </label>
                <input title="Quantidade" min="0" type="number" placeholder="Quantidade" class="input-default form-control" id="txtQuantidadeFilho" name="txtQuantidadeFilho">
                <input title="Ordem" min="0" value="0" type="number" placeholder="Ordem" class="input-default form-control d-none" id="txtOrdemItensFilho" name="txtOrdemItensFilho">
              </div>
              <div class="d-flex align-items-end mt-1 col-sm-6 col-xl-2">
                <button class="btn btn-danger btn-sisp" id="btnAdicionarProdutoFilho" style="width: 100%;"> Adicionar</button>
              </div>

            </div>
          </div>

          <div class="row">
            <div class="col-sm-12 table-responsive card-body px-0 pb-0 pt-0">
              <table id="tabelaProdutosFilhosRelacionados" style="white-space: nowrap" class="table table-sm table-select table-hover" width="100%">
                <thead></thead>
                <tbody></tbody>
              </table>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button class="btn btn-danger btn-sisp" id="btnConfirmarRelacionamento"> Confirmar</button>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modalPartes" tabindex="-1" role="dialog" aria-labelledby="modalPartes" aria-hidden="true">
    <div class="modal-dialog modal-md">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar Parte</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pb-0">
          <div class="form-row">
            <div class="col-lg-12 col-12 pb-3">
              <label data-error="wrong" data-success="right" for="txtParte">Parte:</label>
              <div class="input-group">
                <input class="d-none" type="text" id="txtTabPadrao">
                <input class="d-none" type="text" id="txtCodigoFaccao">
                <select class="drilldown-item form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="txtParte" style="border-color: #a9a9a9">
                  <option class="drilldown-item" value=""></option>
                </select>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button class="btn btn-primary btnBarra btn-sisp" id="btnConfirmarPartes"> Confirmar</button>
            <button class="btn bg-gradient-danger btnBarra btn-sisp" id="btnFecharPartes"> Fechar</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" data-backdrop="static" id="modalAlterarDadosEmMassa" tabindex="-1" role="dialog" aria-labelledby="modalAlterarDadosEmMassa" aria-hidden="true">
    <div class="modal-dialog" style="min-width: 80%; min-height: 100%">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Alterar Dados Em Massa</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pb-0">
          <div class="form-row">
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo2AlterarDados">Código 2:</label>
              <input class="input-default focus form-control campoAlterarDadosEmMassa" id="txtCodigo2AlterarDados" placeholder="Código 2" name="codigo2">
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtDescricaoAlterarDados">Descrição:</label>
              <input class="input-default focus form-control campoAlterarDadosEmMassa" id="txtDescricaoAlterarDados" placeholder="Descrição" name="txtDescricaoAlterarDados">
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtDescricao2AlterarDados">Descrição 2:</label>
              <input class="input-default focus form-control campoAlterarDadosEmMassa" id="txtDescricao2AlterarDados" placeholder="Descrição 2" name="txtDescricao2AlterarDados">
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtStatusAlterarDados">Status:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtStatusAlterarDados" name="txtStatusAlterarDados" placeholder="Status">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnStatusAlterarDados" name="btnStatusAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaStatusAlterarDados" name="btnLimpaStatusAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtGrupoAlterarDados">Grupo:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtGrupoAlterarDados" name="txtGrupoAlterarDados" placeholder="Grupo">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnGrupoAlterarDados" name="btnGrupoAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaGrupoAlterarDados" name="btnLimpaGrupoAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtMarcaAlterarDados">Marca:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtMarcaAlterarDados" name="txtMarcaAlterarDados" placeholder="Marca">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnMarcaAlterarDados" name="btnMarcaAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaMarcaAlterarDados" name="btnLimpaMarcaAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtEtiquetaAlterarDados">Etiqueta:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtEtiquetaAlterarDados" name="txtEtiquetaAlterarDados" placeholder="Etiqueta">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnEtiquetaAlterarDados" name="btnEtiquetaAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaEtiquetaAlterarDados" name="btnLimpaEtiquetaAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigoClienteAlterarDados">Código Cliente:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtCodigoClienteAlterarDados" name="txtCodigoClienteAlterarDados" placeholder="Código Cliente">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnCodigoClienteAlterarDados" name="btnCodigoClienteAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaCodigoClienteAlterarDados" name="btnLimpaCodigoClienteAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtLinhaAlterarDados">Linha:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtLinhaAlterarDados" name="txtLinhaAlterarDados" placeholder="Linha">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnLinhaAlterarDados" name="btnLinhaAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaLinhaAlterarDados" name="btnLimpaLinhaAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtColecaoAlterarDados">Coleção:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtColecaoAlterarDados" name="txtColecaoAlterarDados" placeholder="Coleção">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnColecaoAlterarDados" name="btnColecaoAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaColecaoAlterarDados" name="btnLimpaColecaoAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCategoriaAlterarDados">Categoria:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtCategoriaAlterarDados" name="txtCategoriaAlterarDados" placeholder="Categoria">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnCategoriaAlterarDados" name="btnCategoriaAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaCategoriaAlterarDados" name="btnLimpaCategoriaAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtTipoProdutoAlterarDados">Tipo Produto:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtTipoProdutoAlterarDados" name="txtTipoProdutoAlterarDados" placeholder="Tipo Produto">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnTipoProdutoAlterarDados" name="btnTipoProdutoAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaTipoProdutoAlterarDados" name="btnLimpaTipoProdutoAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtModeloAlterarDados">Modelo:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtModeloAlterarDados" name="txtModeloAlterarDados" placeholder="Modelo">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnModeloAlterarDados" name="btnModeloAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaModeloAlterarDados" name="btnLimpaModeloAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigoNcmAlterarDados">Código NCM:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtCodigoNcmAlterarDados" name="txtCodigoNcmAlterarDados" placeholder="Código NCM">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnCodigoNcmAlterarDados" name="btnCodigoNcmAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaCodigoNcmAlterarDados" name="btnLimpaCodigoNcmAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstIcmsAlterarDados">CST ICMS:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtCstIcmsAlterarDados" name="txtCstIcmsAlterarDados" placeholder="CST ICMS">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnCstIcmsAlterarDados" name="btnCstIcmsAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaCstIcmsAlterarDados" name="btnLimpaCstIcmsAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstIpiSaidaAlterarDados">CST IPI Saída:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtCstIpiSaidaAlterarDados" name="txtCstIpiSaidaAlterarDados" placeholder="CST IPI Saída">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnCstIpiSaidaAlterarDados" name="btnCstIpiSaidaAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaCstIpiSaidaAlterarDados" name="btnLimpaCstIpiSaidaAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstIpiEntradaAlterarDados">CST IPI Entrada:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtCstIpiEntradaAlterarDados" name="txtCstIpiEntradaAlterarDados" placeholder="Código NCM">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnCstIpiEntradaAlterarDados" name="btnCstIpiEntradaAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaCstIpiEntradaAlterarDados" name="btnLimpaCstIpiEntradaAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="selectPosseAlterarDados">Posse:</label>
              <select class="input-default focus form-control campoAlterarDadosEmMassa" title='Quando a opção selecionada for "Não informado", esse campo não será atualizado.' data-dropdown-css-class="select2-danger" id="selectPosseAlterarDados" aria-describedby="tipoError" class="custom-select focus">
                <option value="">Não informado</option>
                <option value="0">0 - Mercadoria de propriedade do informante e em seu poder</option>
                <option value="1">1 - Mercadoria de propriedade do informante em poder de terceiros</option>
                <option value="2">2 - Mercadoria de propriedade de terceiros em poder do informante</option>
              </select>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="selectImportadoAlterarDados">Importado:</label>
              <select class="input-default focus form-control campoAlterarDadosEmMassa" title='Quando a opção selecionada for "Não informado", esse campo não será atualizado.' data-dropdown-css-class="select2-danger" id="selectImportadoAlterarDados" aria-describedby="tipoError" class="custom-select focus">
                <option value="">Não informado</option>
                <option value="N">Não</option>
                <option value="D">Diretamente</option>
                <option value="I">Indiretamente</option>
              </select>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="selectAtivoAlterarDados">Ativo:</label>
              <select class="input-default focus form-control campoAlterarDadosEmMassa" title='Quando a opção selecionada for "Não informado", esse campo não será atualizado.' data-dropdown-css-class="select2-danger" id="selectAtivoAlterarDados" aria-describedby="tipoError" class="custom-select focus">
                <option value="">Não informado</option>
                <option value="S">Sim</option>
                <option value="N">Não</option>
              </select>
            </div>
          </div>
          <div class="modal-footer px-0">
            <button type="submit" class="btn btn-primary btn-sisp" id="btnConfirmarAlterarDados">Confirmar</button>
            <button class="btn btn-danger btn-sisp" id="btnLimparCamposAlterarDados"><span class="fas fa-trash"></span>Limpar Campos</button>
            <button class="btn btn-danger btn-sisp" class="close" data-dismiss="modal" aria-label="Close" id="btnCancelarAlterarDados">Cancelar</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" data-backdrop="static" id="modalUtilizacao" tabindex="-1" role="dialog" aria-labelledby="modalUtilizacao" aria-hidden="true">
    <div class="modal-dialog" style="min-width: 97%; min-height: 100vh">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Utilização</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pb-0">
          <div class="form-row">
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtProdutoUtilizacao">Produto: </label>
              <div class="relative">
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtProdutoUtilizacao" name="txtProdutoUtilizacao" multiple="multiple"></select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnProdutoUtilizacao" name="btnProdutoUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaProdutoUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtColecaoUtilizacao">Coleção: </label>
              <div class="relative">
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtColecaoUtilizacao" name="txtColecaoUtilizacao" multiple="multiple"></select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnColecaoUtilizacao" name="btnColecaoUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaColecaoUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtMarcaUtilizacao">Marca: </label>
              <div class="relative">
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtMarcaUtilizacao" name="txtMarcaUtilizacao" multiple="multiple"></select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnMarcaUtilizacao" name="btnMarcaUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaMarcaUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtGrupoUtilizacao">Grupo: </label>
              <div class="relative">
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtGrupoUtilizacao" name="txtGrupoUtilizacao" multiple="multiple"></select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnGrupoUtilizacao" name="btnGrupoUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaGrupoUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtLinhaUtilizacao">Linha: </label>
              <div class="relative">
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtLinhaUtilizacao" name="txtLinhaUtilizacao" multiple="multiple"></select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnLinhaUtilizacao" name="btnLinhaUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaLinhaUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtStatusUtilizacao">Status: </label>
              <div class="relative">
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtStatusUtilizacao" name="txtStatusUtilizacao" multiple="multiple"></select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnStatusUtilizacao" name="btnStatusUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaStatusUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtEtiquetaUtilizacao">Etiqueta: </label>
              <div class="relative">
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtEtiquetaUtilizacao" name="txtEtiquetaUtilizacao" multiple="multiple"></select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnEtiquetaUtilizacao" name="btnEtiquetaUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaEtiquetaUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtModeloUtilizacao">Modelo: </label>
              <div class="relative">
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtModeloUtilizacao" name="txtModeloUtilizacao" multiple="multiple"></select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnModeloUtilizacao" name="btnModeloUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaModeloUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtCorUtilizacao">Cor: </label>
              <div class="relative">
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtCorUtilizacao" name="txtCorUtilizacao" multiple="multiple"></select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnCorUtilizacao" name="btnCorUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaCorUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-1 col-lg-2 col-md-3 col-6 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="selectSituacaoUtilizacao">Situação:</label>
              <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="selectSituacaoUtilizacao" aria-describedby="tipoError" class="custom-select focus">
                <option value="">Todos</option>
                <option value="S">Ativos</option>
                <option value="N">Inativos</option>
              </select>
            </div>
            <div class="col-xl-1 col-lg-2 col-md-3 col-6 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="selectSituacaoCorUtilizacao">Situação Cor:</label>
              <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="selectSituacaoCorUtilizacao" aria-describedby="tipoError" class="custom-select focus">
                <option value="">Todos</option>
                <option value="S">Ativos</option>
                <option value="N">Inativas</option>
              </select>
            </div>
            <div class="flex form-group ml-1 align-items-end">
              <button class="btn btn-primary btn-sisp" id="btnConsultarUtilizacao"><i class="fas fa-search"></i>Consultar</button>
            </div>
          </div>
          <div class="form-row">
            <div class="flex flex-column col-6">
              <div class="bordaTabelasUtilizacao">
                <h5 class="mb-0">Itens</h5>
                <div class="table-responsive">
                  <table id="tabelaItensUtilizacao" class="table table-sm table-select table-hover" width="100%">
                    <thead>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
            <div class="flex flex-column col-6">
              <div class="bordaTabelasUtilizacao">
                <h5 class="mb-0">Cores</h5>
                <div class="table-responsive">
                  <table id="tabelaCoresUtilizacao" class="table table-sm table-select table-hover" width="100%">
                    <thead>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
            <div class="flex flex-column col-12 my-2">
              <div class="bordaTabelasUtilizacao">
                <h5 class="mb-0">Produtos</h5>
                <div class="table-responsive">
                  <table id="tabelaProdutosUtilizacao" class="table table-select table-hover" width="100%">
                    <thead>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button class="btn btn-danger btn-sisp" id="btnLimparFiltrosUtilizacao"><i class="fas fa-trash"></i>Limpar Filtros</button>
          <button class="btn btn-danger btn-sisp" class="close" data-dismiss="modal" aria-label="Close" id="btnFecharUtilizacao">Fechar</button>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" data-backdrop="static" id="modalDuplicar" tabindex="-1" role="dialog" aria-labelledby="modalDuplicar" aria-hidden="true">
    <div class="modal-dialog modal-md">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Duplicar Produto</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pb-0">
          <div class="form-row">
            <div class="col-4 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtProdutoDuplicar">Novo código:</label>
              <input type="text" class="input-default focus form-control" id="txtProdutoDuplicar" name="txtProdutoDuplicar" placeholder="Código">
              <input type="text" class="input-default focus form-control d-none" id="txtProdutoOriginalDuplicar" name="txtProdutoOriginalDuplicar">
            </div>
          </div>
          <div class="form-row">
            <div class=" col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtFaixaTam">Faixa de Tamanho: *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtFaixaTam" name="txtFaixaTam" placeholder="Faixa de Tamanho">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnSearchFaixaTam" name="btnSearchFaixaTam" data-button="absolute" type="button">
                    <i class="m-0 p-0 fas fa-search"></i>
                  </button>
                  <button class="btn bg-danger" id="btnClearFaixaTam" name="btnClearFaixaTam" type="button">
                    <i class="m-0 p-0 fas fa-trash"></i>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-danger btn-sisp" id="btnConfirmarDuplicar">Confirmar</button>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="imagemodal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-body">
          <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
          <img src="" class="imagepreview" style="width: 100%;">
        </div>
      </div>
    </div>
  </div>

  <?php
  include_once('../../../modais.php');
  include_once('../../../modals/modal_anexos.html');
  include_once('../../../modals/modal_medidas.html');
  include_once('../../../modals/modal_combinacao.html');
  include_once('../../../modals/modal_histprod.html');
  include_once('../../../modals/modal_fluxo_produto.html');
  include_once('../../../modals/modal_proditensest.html');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.261.6.2"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.261.6.2"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.261.6.2"></script>
  <script src="dist/js/adminlte.min.js?versao=3.261.6.2"></script>
  <script src="dist/js/sisplan.js?versao=3.261.6.2"></script>
  <script src="utils/funcoes.js?versao=3.261.6.2"></script>
  <script src="utils/cookies.js?versao=3.261.6.2"></script>
  <script src="dist/js/requisicoes.js?versao=3.261.6.2"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.261.6.2"></script>
  <script src="dist/js/driver.min.js?versao=3.261.6.2"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="config.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="modals/modal_anexos.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="modals/modal_medidas.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="modals/modal_combinacao.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="modals/modal_histprod.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="modals/modal_fluxo_produto.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="modals/modal_proditensest.js?versao=3.261.6.2"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.261.6.2"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.261.6.2"></script>
  <script src="dist/js/dataTables.keyTable2.js?versao=3.261.6.2"></script>
  <script src="https://cdn.datatables.net/select/1.6.0/js/dataTables.select.min.js"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.261.6.2"></script>
  <script src="https://cdn.jsdelivr.net/npm/html-to-rtf@2.1.0/app/browser/bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/rtf-html@1.0.3/dist/rtf-html.min.js"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('PRODUTO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/produto/acesso_produto/acesso_produto.js?versao=3.261.6.2`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>